<?php
/**
 * Plugin Name:           AutomatorWP - LifterLMS
 * Plugin URI:            https://automatorwp.com/add-ons/lifterlms/
 * Description:           Connect AutomatorWP with LifterLMS.
 * Version:               1.0.4
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-lifterlms
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\LifterLMS
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_LifterLMS {

    /**
     * @var         AutomatorWP_LifterLMS $instance The one true AutomatorWP_LifterLMS
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_LifterLMS self::$instance The one true AutomatorWP_LifterLMS
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_LifterLMS();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_LIFTERLMS_VER', '1.0.4' );

        // Plugin file
        define( 'AUTOMATORWP_LIFTERLMS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_LIFTERLMS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_LIFTERLMS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/complete-quiz.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/complete-lesson.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/complete-section.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/enroll-course.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/complete-course.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/enroll-membership.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/purchase-access-plan.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/earn-certificate.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/submit-assignment.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/triggers/complete-assignment.php';

            // Actions
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/actions/reset-quiz.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/actions/mark-lesson.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/actions/mark-section.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/actions/mark-course.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/actions/user-course.php';
            require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/actions/user-membership.php';

            // Filters
            if ( class_exists( 'LifterLMS_Groups' ) ) {
                require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/filters/user-is-added-group.php';
                require_once AUTOMATORWP_LIFTERLMS_DIR . 'includes/filters/user-is-not-added-group.php';
            }

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'lifterlms', array(
            'label' => 'LifterLMS',
            'icon'  => AUTOMATORWP_LIFTERLMS_URL . 'assets/lifterlms.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'LifterLMS' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_LifterLMS instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_LifterLMS The one true AutomatorWP_LifterLMS
 */
function AutomatorWP_LifterLMS() {
    return AutomatorWP_LifterLMS::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_LifterLMS' );
